/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_UTILITY_ERRORS_H
#define _SCE_UTILITY_ERRORS_H


#define SCE_TOOLKIT_NP_SUCCESS											0			///< The operation was successfully completed.

#define SCE_TOOLKIT_NP_INVALID_POINTER									0x81000011	///< An error occurred because an invalid pointer was passed as an argument.
#define SCE_TOOLKIT_NP_OUT_OF_MEMORY									0x81000012	///< An error occurred because memory allocation failed.
#define SCE_TOOLKIT_NP_INVALID_ARGUMENT									0x81000013	///< An error occurred because an argument passed to a method was incorrect.

// synchronisation errors //  may be platform dependent so slightly different numbering?
#define SCE_TOOLKIT_NP_LOCK_ERRORS										0x82000000	///< A general locking error occurred.
#define SCE_TOOLKIT_NP_LOCK_ERROR_TIMEOUT								0x82000001	///< An error occurred because a lock timed out. Locks are indefinite currently so this should not happen.
#define SCE_TOOLKIT_NP_LOCK_ERROR_ALREADY_OWNED							0x82000002	///< An error occurred because the lock is already owned by another thread.
#define SCE_TOOLKIT_NP_LOCK_ERROR_UNKNOWN								0x82000004	///< An unknown error occurred.
#define SCE_TOOLKIT_NP_LOCK_ERROR_OUT_OF_IDS							0x82000005	///< An error occurred because no more Lock IDs could be allocated.
#define SCE_TOOLKIT_NP_LOCK_ERROR_COND_EXISTS							0x82000006	///< An error occurred because a condition variable still exists related to this mutex.
#define	SCE_TOOLKIT_NP_LOCK_ERROR_NOT_RECURSIVE							0x82000007	///< An error occurred because a mutex cannot be recursively owned.
#define SCE_TOOLKIT_NP_LOCK_ERROR_ID_INVALID							0x82000008	///< An error occurred because an ID for a mutex has become invalid.
#define SCE_TOOLKIT_NP_FUTURE_RESET										0x82000009	///< An error occurred because this future has been reset.

#endif
